/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ceutils;

import com.filenet.apiimpl.util.Crypto;
import com.filenet.apiimpl.util.UTF8Helper;
import filenet.pe.ceutils.PeApiKac;
import filenet.pe.peorb.client.IdTypeFlagsHolder;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.security.Key;
import java.util.zip.CRC32;
import javax.crypto.spec.SecretKeySpec;

public class IdTypeFlags {
    private static final byte IDENTITY_TOKEN_VERSION_NUMBER = 1;
    private static final String m_className = "IdTypeFLags";
    private static Logger logger = Logger.getLogger("filenet.pe.ceutils.token");

    private static byte[] validateVersionNumber(byte[] token) throws VWException {
        String m_method = "validateVersionNumber";
        byte versionNumber = token[0];
        if (versionNumber != 1) {
            VWException vwex = new VWException("filenet.pe.ceutils.IdTypeFlags.version token.mismatched", "Version number mismatch:  expected {0} got {1}", new Object[]{Byte.toString((byte)1), Byte.toString(versionNumber)});
            logger.throwing(m_className, "validateVersionNumber", vwex);
        }
        byte[] result = new byte[token.length - 1];
        System.arraycopy(token, 1, result, 0, token.length - 1);
        return result;
    }

    private static byte[] validateChecksum(byte[] checksummedData) throws VWException {
        int commaPos = IdTypeFlags.findNthCommaPosition(1, checksummedData);
        byte[] encodedChecksum = IdTypeFlags.subArray(checksummedData, 0, commaPos);
        byte[] encodedData = IdTypeFlags.subArray(checksummedData, commaPos + 1, checksummedData.length - commaPos - 1);
        CRC32 crc = new CRC32();
        crc.update(encodedData);
        long gottenChecksum = crc.getValue();
        String checkSumString = UTF8Helper.decodeString((byte[])encodedChecksum);
        long expectedCheckSum = Long.decode(checkSumString);
        if (expectedCheckSum != gottenChecksum) {
            VWException vwex = new VWException("filenet.pe.ceutils.IdTypeFlags.checksum.mismatched", "Checksum mismatch:  expected {0} got {1}", new Object[]{Long.toString(expectedCheckSum), Long.toString(gottenChecksum)});
            logger.throwing(m_className, "validateChecksum", vwex);
            throw vwex;
        }
        return encodedData;
    }

    private static int findNthCommaPosition(int n, byte[] data) throws VWException {
        String m_method = "findNthCommandPosition:" + n;
        int commaPos = -1;
        int commasFound = 0;
        for (int i = 0; i < data.length && commasFound < n; ++i) {
            if (44 != data[i]) continue;
            commaPos = i;
            ++commasFound;
        }
        if (-1 == commaPos) {
            VWException vwex = new VWException("filenet.pe.ceutils.IdTypeFlags.nocomma", "could not find position of comma number {0}", new Object[]{Integer.toString(n)});
            logger.throwing(m_className, m_method, vwex);
        }
        return commaPos;
    }

    private static byte[] subArray(byte[] in, int start, int length) {
        byte[] result = new byte[length];
        System.arraycopy(in, start, result, 0, length);
        return result;
    }

    private static SecretKeySpec decodeEncryptionKey(byte[] encodedKey) throws VWException {
        String m_method = "decodeEncryptionKey";
        SecretKeySpec ks = null;
        String algorithm = PeApiKac.getDesc().split("/")[0];
        try {
            ks = new SecretKeySpec(encodedKey, algorithm);
        }
        catch (Exception e) {
            logger.throwing(m_className, "decodeEncryptionKey", e);
            throw new VWException(e);
        }
        return ks;
    }

    private static byte[] decrypt(byte[] encodedKey, byte[] cipherText) throws VWException {
        return Crypto.decryptBytes((String)PeApiKac.getDesc(), (Key)IdTypeFlags.decodeEncryptionKey(encodedKey), (byte[])cipherText);
    }

    private static String hexEncode(byte[] input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            String oneByte = Integer.toHexString(input[i] & 0xFF);
            if (1 == oneByte.length()) {
                sb.append('0');
            }
            sb.append(oneByte);
        }
        return sb.toString();
    }

    private static byte[] hexDecode(byte[] in) throws IllegalArgumentException {
        if (in == null) {
            return null;
        }
        String s = new String(in).toUpperCase();
        int nBytes = s.length();
        if (nBytes % 2 != 0) {
            return null;
        }
        byte[] res = new byte[nBytes / 2];
        int j = 0;
        for (int i = 0; i < nBytes; i += 2) {
            res[j] = (byte)(Integer.parseInt(s.substring(i, i + 2), 16) & 0xFF);
            ++j;
        }
        return res;
    }

    public static void extract(byte[] versionedToken, IdTypeFlagsHolder typeFlagHolder) throws VWException {
        byte[] encryptedToken = IdTypeFlags.validateVersionNumber(versionedToken);
        byte[] checksummedToken = IdTypeFlags.decrypt(PeApiKac.getVector(), encryptedToken);
        byte[] concatenatedToken = IdTypeFlags.validateChecksum(checksummedToken);
        int userNameCommaPos = IdTypeFlags.findNthCommaPosition(1, concatenatedToken);
        int TokenCommaPos = IdTypeFlags.findNthCommaPosition(2, concatenatedToken);
        typeFlagHolder.key = IdTypeFlags.hexDecode(IdTypeFlags.subArray(concatenatedToken, 0, userNameCommaPos));
        typeFlagHolder.name = IdTypeFlags.subArray(concatenatedToken, userNameCommaPos + 1, TokenCommaPos - userNameCommaPos - 1);
        typeFlagHolder.token = IdTypeFlags.subArray(concatenatedToken, TokenCommaPos + 1, concatenatedToken.length - TokenCommaPos - 1);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:45:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    public static void main(String[] args) {
        try {
            byte[] res = new byte[]{-84, -34, -2, 29};
            String s = IdTypeFlags.hexEncode(res);
            byte[] byArray = IdTypeFlags.hexDecode(s.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

